"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAngularCompilerHost = exports.ensureSourceFileVersions = void 0;
const typescript_1 = __importDefault(require("typescript"));
// Temporary deep import for host augmentation support.
// TODO: Move these to a private exports location or move the implementation into this package.
const { augmentHostWithCaching, augmentHostWithReplacements, augmentProgramWithVersioning, } = require('@ngtools/webpack/src/ivy/host');
/**
 * Patches in-place the `getSourceFiles` function on an instance of a TypeScript
 * `Program` to ensure that all returned SourceFile instances have a `version`
 * field. The `version` field is required when used with a TypeScript BuilderProgram.
 * @param program The TypeScript Program instance to patch.
 */
function ensureSourceFileVersions(program) {
    augmentProgramWithVersioning(program);
}
exports.ensureSourceFileVersions = ensureSourceFileVersions;
function createAngularCompilerHost(compilerOptions, hostOptions) {
    // Create TypeScript compiler host
    const host = typescript_1.default.createIncrementalCompilerHost(compilerOptions);
    // The AOT compiler currently requires this hook to allow for a transformResource hook.
    // Once the AOT compiler allows only a transformResource hook, this can be reevaluated.
    host.readResource = async function (filename) {
        var _a;
        return (_a = this.readFile(filename)) !== null && _a !== void 0 ? _a : '';
    };
    // Add an AOT compiler resource transform hook
    host.transformResource = async function (data, context) {
        var _a;
        // Only style resources are transformed currently
        if (context.type !== 'style') {
            return null;
        }
        const result = await hostOptions.transformStylesheet(data, context.containingFile, (_a = context.resourceFile) !== null && _a !== void 0 ? _a : undefined);
        return result ? { content: result } : null;
    };
    // Allow the AOT compiler to request the set of changed templates and styles
    host.getModifiedResourceFiles = function () {
        return hostOptions.modifiedFiles;
    };
    // Augment TypeScript Host for file replacements option
    if (hostOptions.fileReplacements) {
        augmentHostWithReplacements(host, hostOptions.fileReplacements);
    }
    // Augment TypeScript Host with source file caching if provided
    if (hostOptions.sourceFileCache) {
        augmentHostWithCaching(host, hostOptions.sourceFileCache);
    }
    return host;
}
exports.createAngularCompilerHost = createAngularCompilerHost;
//# sourceMappingURL=data:application/json;base64,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