/**
 * UMD/CJS bundles generated by Rollup may be using an element access expression like
 * `exports["ɵa"]` for declaring and exporting classes, instead of a property access like
 * `exports.ɵa`. The element access syntax introduces a problem for ngcc, where it wouldn't consider
 * such export as class declaration, causing them to be skipped. The ngtsc compiler is implemented
 * with the assumption that all class declarations use a `ts.Identifier` as name, whereas the
 * element access is using a string literal for the declared name. This makes it troublesome for
 * ngcc to support this syntax form in UMD bundles.
 *
 * To work around the problem, this function transforms these access expressions into regular
 * property accesses. The source text is parsed to an AST to allow finding the element accesses in a
 * robust way, after which the affected text ranges are replaced with property accesses in the
 * original source text. These replacement operations are faster than applying an AST transform and
 * going through a `ts.Printer` to print the text back out.
 */
export declare function adjustElementAccessExports(sourceText: string): string;
