/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @module
 * @description
 * Entry point from which you should import all public core APIs.
 */
export * from './metadata';
export * from './version';
export * from './di';
export { createPlatform, assertPlatform, destroyPlatform, getPlatform, PlatformRef, ApplicationRef, createPlatformFactory, NgProbeToken, APP_BOOTSTRAP_LISTENER } from './application_ref';
export { enableProdMode, isDevMode } from './util/is_dev_mode';
export { APP_ID, PACKAGE_ROOT_URL, PLATFORM_INITIALIZER, PLATFORM_ID, ANIMATION_MODULE_TYPE } from './application_tokens';
export { APP_INITIALIZER, ApplicationInitStatus } from './application_init';
export * from './zone';
export * from './render';
export * from './linker';
export * from './linker/ng_module_factory_loader_impl';
export { DebugElement, DebugEventListener, DebugNode, asNativeElements, getDebugNode } from './debug/debug_node';
export { Testability, TestabilityRegistry, setTestabilityGetter } from './testability/testability';
export * from './change_detection';
export * from './platform_core_providers';
export { TRANSLATIONS, TRANSLATIONS_FORMAT, LOCALE_ID, DEFAULT_CURRENCY_CODE, MissingTranslationStrategy } from './i18n/tokens';
export { ApplicationModule } from './application_module';
export { Type } from './interface/type';
export { EventEmitter } from './event_emitter';
export { ErrorHandler } from './error_handler';
export * from './core_private_export';
export * from './core_render3_private_export';
export { SecurityContext } from './sanitization/security';
export { Sanitizer } from './sanitization/sanitizer';
export { createNgModule, createNgModuleRef, createEnvironmentInjector } from './render3/ng_module_ref';
export { createComponent, reflectComponentType } from './render3/component';
export { isStandalone } from './render3/definition';
import { global } from './util/global';
if (typeof ngDevMode !== 'undefined' && ngDevMode) {
    // This helper is to give a reasonable error message to people upgrading to v9 that have not yet
    // installed `@angular/localize` in their app.
    // tslint:disable-next-line: no-toplevel-property-access
    global.$localize = global.$localize || function () {
        throw new Error('It looks like your application or one of its dependencies is using i18n.\n' +
            'Angular 9 introduced a global `$localize()` function that needs to be loaded.\n' +
            'Please run `ng add @angular/localize` from the Angular CLI.\n' +
            '(For non-CLI projects, add `import \'@angular/localize/init\';` to your `polyfills.ts` file.\n' +
            'For server-side rendering applications add the import to your `main.server.ts` file.)');
    };
}
//# sourceMappingURL=data:application/json;base64,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