import { DatepickerRenderOptions, BsDatepickerViewMode, DatepickerDateCustomClasses, DatepickerDateTooltipText } from './models';
import { BsCustomDates } from './themes/bs/bs-custom-dates-view.component';
import * as i0 from "@angular/core";
/**
 * For date range picker there are `BsDaterangepickerConfig` which inherits all properties,
 * except `displayMonths`, for range picker it default to `2`
 */
export declare class BsDatepickerConfig implements DatepickerRenderOptions {
    /** sets use adaptive position */
    adaptivePosition: boolean;
    /** sets use UTC date time format */
    useUtc: boolean;
    /** turn on/off animation */
    isAnimated: boolean;
    value?: Date | Date[];
    isDisabled?: boolean;
    /**
     * Default min date for all date/range pickers
     */
    minDate?: Date;
    /**
     * Default max date for all date/range pickers
     */
    maxDate?: Date;
    /**
     * The view that the datepicker should start in
     */
    startView: BsDatepickerViewMode;
    /**
     * Default date custom classes for all date/range pickers
     */
    dateCustomClasses?: DatepickerDateCustomClasses[];
    /**
     * Default tooltip text for all date/range pickers
     */
    dateTooltipTexts?: DatepickerDateTooltipText[];
    /**
     * Disable specific days, e.g. [0,6] will disable all Saturdays and Sundays
     */
    daysDisabled?: number[];
    /**
     * Disable specific dates
     */
    datesDisabled?: Date[];
    /**
     * Show one months for special cases (only for dateRangePicker)
     * 1. maxDate is equal to today's date
     * 2. minDate's month is equal to maxDate's month
     */
    displayOneMonthRange?: boolean;
    /**
     * Enable specific dates
     */
    datesEnabled?: Date[];
    /**
     * Makes dates from other months active
     */
    selectFromOtherMonth?: boolean;
    /**
     * Allows select first date of the week by click on week number
     */
    selectWeek?: boolean;
    /**
     * Allows select daterange as first and last day of week by click on week number (dateRangePicker only)
     */
    selectWeekDateRange?: boolean;
    /**
     * Shows previous and current month, instead of current and next (dateRangePicker only)
     */
    showPreviousMonth?: boolean;
    /**
     * Prevents change to next month for right calendar in two calendars view (dateRangePicker only)
     */
    preventChangeToNextMonth?: boolean;
    /**
     * Add class to current day
     */
    customTodayClass?: string;
    /**
     * Default mode for all date pickers
     */
    minMode?: BsDatepickerViewMode;
    /**
     * If true, returns focus to the datepicker / daterangepicker input after date selection
     */
    returnFocusToInput: boolean;
    /** CSS class which will be applied to datepicker container,
     * usually used to set color theme
     */
    containerClass: string;
    displayMonths: number;
    /**
     * Allows to hide week numbers in datepicker
     */
    showWeekNumbers: boolean;
    dateInputFormat: string;
    rangeSeparator: string;
    /**
     * Date format for date range input field
     */
    rangeInputFormat: string;
    /**
     * Predefined ranges
     */
    ranges?: BsCustomDates[];
    /**
     * Max Date Range in days
     */
    maxDateRange?: number;
    monthTitle: string;
    yearTitle: string;
    dayLabel: string;
    monthLabel: string;
    yearLabel: string;
    weekNumbers: string;
    /**
     * Shows 'today' button
     */
    showTodayButton: boolean;
    /**
     * Shows clear button
     */
    showClearButton: boolean;
    /**
     * Positioning of 'today' button
     */
    todayPosition: string;
    /**
     * Positioning of 'clear' button
     */
    clearPosition: string;
    /**
     * Label for 'today' button
     */
    todayButtonLabel: string;
    /**
     * Label for 'clear' button
     */
    clearButtonLabel: string;
    /**
     * Label for 'custom range' button
     */
    customRangeButtonLabel: string;
    /**
     * Shows timepicker under datepicker
     */
    withTimepicker: boolean;
    /**
     * Set current hours, minutes, seconds and milliseconds for bsValue
     */
    initCurrentTime?: boolean;
    /**
     * Set allowed positions of container.
     */
    allowedPositions: string[];
    /**
     * Set rule for datepicker closing. If value is true datepicker closes only if date is changed, if user changes only time datepicker doesn't close. It is available only if property withTimepicker is set true
     * */
    keepDatepickerOpened: boolean;
    static ɵfac: i0.ɵɵFactoryDeclaration<BsDatepickerConfig, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<BsDatepickerConfig>;
}
