import { animate, style, state, transition, trigger } from '@angular/animations';
export const DATEPICKER_ANIMATION_TIMING = '220ms cubic-bezier(0, 0, 0.2, 1)';
export const datepickerAnimation = trigger('datepickerAnimation', [
    state('animated-down', style({ height: '*', overflow: 'hidden' })),
    transition('* => animated-down', [
        style({ height: 0, overflow: 'hidden' }),
        animate(DATEPICKER_ANIMATION_TIMING)
    ]),
    state('animated-up', style({ height: '*', overflow: 'hidden' })),
    transition('* => animated-up', [
        style({ height: '*', overflow: 'hidden' }),
        animate(DATEPICKER_ANIMATION_TIMING)
    ]),
    transition('* => unanimated', animate('0s'))
]);
//# sourceMappingURL=data:application/json;base64,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