import { AfterViewInit, ElementRef, EventEmitter, OnDestroy, OnInit, Renderer2 } from '@angular/core';
import { Subscription } from 'rxjs';
import { PositioningService } from 'ngx-bootstrap/positioning';
import { TimepickerComponent } from 'ngx-bootstrap/timepicker';
import { BsDatepickerAbstractComponent } from '../../base/bs-datepicker-container';
import { BsDatepickerConfig } from '../../bs-datepicker.config';
import { CalendarCellViewModel, DayViewModel } from '../../models';
import { BsDatepickerActions } from '../../reducer/bs-datepicker.actions';
import { BsDatepickerEffects } from '../../reducer/bs-datepicker.effects';
import { BsDatepickerStore } from '../../reducer/bs-datepicker.store';
import * as i0 from "@angular/core";
export declare class BsDatepickerContainerComponent extends BsDatepickerAbstractComponent implements OnInit, AfterViewInit, OnDestroy {
    private _config;
    private _store;
    private _element;
    private _actions;
    private _positionService;
    valueChange: EventEmitter<Date>;
    animationState: string;
    isRangePicker: boolean;
    _subs: Subscription[];
    startTimepicker?: TimepickerComponent;
    set value(value: Date | undefined);
    get isDatePickerDisabled(): boolean;
    get isDatepickerDisabled(): "" | null;
    get isDatepickerReadonly(): "" | null;
    constructor(_renderer: Renderer2, _config: BsDatepickerConfig, _store: BsDatepickerStore, _element: ElementRef, _actions: BsDatepickerActions, _effects: BsDatepickerEffects, _positionService: PositioningService);
    ngOnInit(): void;
    ngAfterViewInit(): void;
    get isTopPosition(): boolean;
    positionServiceEnable(): void;
    timeSelectHandler(date: Date, index: number): void;
    daySelectHandler(day: DayViewModel): void;
    monthSelectHandler(day: CalendarCellViewModel): void;
    yearSelectHandler(day: CalendarCellViewModel): void;
    setToday(): void;
    clearDate(): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<BsDatepickerContainerComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<BsDatepickerContainerComponent, "bs-datepicker-container", never, {}, {}, never, never, false, never>;
}
