import { BehaviorSubject, queueScheduler } from 'rxjs';
import { observeOn, scan } from 'rxjs/operators';
export class MiniState extends BehaviorSubject {
    constructor(_initialState, actionsDispatcher$, reducer) {
        super(_initialState);
        const actionInQueue$ = actionsDispatcher$.pipe(observeOn(queueScheduler));
        const state$ = actionInQueue$.pipe(scan((state, action) => {
            if (!action) {
                return state;
            }
            return reducer(state, action);
        }, _initialState));
        state$.subscribe((value) => this.next(value));
    }
}
//# sourceMappingURL=data:application/json;base64,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