import { PlacementForBs5 } from '../models';
import { checkMargins } from './checkMargin';
import { getBsVer } from 'ngx-bootstrap/utils';
export function updateContainerClass(data, renderer) {
    const target = data.instance.target;
    let containerClass = target.className;
    const dataPlacement = getBsVer().isBs5 ? PlacementForBs5[data.placement] : data.placement;
    if (data.placementAuto) {
        containerClass = containerClass.replace(/bs-popover-auto/g, `bs-popover-${dataPlacement}`);
        containerClass = containerClass.replace(/ms-2|me-2|mb-2|mt-2/g, '');
        containerClass = containerClass.replace(/bs-tooltip-auto/g, `bs-tooltip-${dataPlacement}`);
        containerClass = containerClass.replace(/\sauto/g, ` ${dataPlacement}`);
        if (containerClass.indexOf('popover') !== -1) {
            containerClass = containerClass + ' ' + checkMargins(dataPlacement);
        }
        if (containerClass.indexOf('popover') !== -1 && containerClass.indexOf('popover-auto') === -1) {
            containerClass += ' popover-auto';
        }
        if (containerClass.indexOf('tooltip') !== -1 && containerClass.indexOf('tooltip-auto') === -1) {
            containerClass += ' tooltip-auto';
        }
    }
    containerClass = containerClass.replace(/left|right|top|bottom|end|start/g, `${dataPlacement.split(' ')[0]}`);
    if (renderer) {
        renderer.setAttribute(target, 'class', containerClass);
        return;
    }
    target.className = containerClass;
}
//# sourceMappingURL=data:application/json;base64,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