import { ChangeDetectorRef, ElementRef, OnDestroy, Renderer2, TemplateRef, EventEmitter } from '@angular/core';
import { PositioningService } from 'ngx-bootstrap/positioning';
import { Subscription } from 'rxjs';
import { TypeaheadMatch } from './typeahead-match.class';
import { TypeaheadDirective } from './typeahead.directive';
import { TypeaheadOptionItemContext, TypeaheadOptionListContext, TypeaheadTemplateMethods } from './models';
import * as i0 from "@angular/core";
export declare class TypeaheadContainerComponent implements OnDestroy {
    private positionService;
    private renderer;
    element: ElementRef;
    private changeDetectorRef;
    activeChangeEvent: EventEmitter<any>;
    parent?: TypeaheadDirective;
    query?: string[] | string;
    isFocused: boolean;
    top?: string;
    left?: string;
    display?: string;
    placemen?: string;
    dropup?: boolean;
    guiHeight?: string;
    needScrollbar?: boolean;
    animationState?: string;
    positionServiceSubscription: Subscription;
    height: number;
    popupId: string;
    get typeaheadTemplateMethods(): TypeaheadTemplateMethods;
    protected _active?: TypeaheadMatch;
    protected _matches: TypeaheadMatch[];
    private ulElement?;
    private liElements?;
    constructor(positionService: PositioningService, renderer: Renderer2, element: ElementRef, changeDetectorRef: ChangeDetectorRef);
    get active(): TypeaheadMatch | undefined;
    set active(active: TypeaheadMatch | undefined);
    get matches(): TypeaheadMatch[];
    set matches(value: TypeaheadMatch[]);
    get isTopPosition(): boolean;
    get optionsListTemplate(): TemplateRef<TypeaheadOptionListContext> | undefined;
    get isAnimated(): boolean;
    get adaptivePosition(): boolean;
    get typeaheadScrollable(): boolean;
    get typeaheadOptionsInScrollableView(): number;
    get typeaheadIsFirstItemActive(): boolean;
    get itemTemplate(): TemplateRef<TypeaheadOptionItemContext> | undefined;
    get canSelectItemsOnBlur(): boolean;
    selectActiveMatch(isActiveItemChanged?: boolean): void;
    activeChanged(): void;
    prevActiveMatch(): void;
    nextActiveMatch(): void;
    selectActive(value: TypeaheadMatch): void;
    highlight(match: TypeaheadMatch, query: string[] | string): string;
    focusLost(): void;
    isActive(value: TypeaheadMatch): boolean;
    selectMatch(value?: TypeaheadMatch, event?: Event): boolean;
    setScrollableMode(): void;
    scrollPrevious(index: number): void;
    scrollNext(index: number): void;
    ngOnDestroy(): void;
    protected setActive(value?: TypeaheadMatch): void;
    private isScrolledIntoView;
    private scrollToBottom;
    private scrollToTop;
    static ɵfac: i0.ɵɵFactoryDeclaration<TypeaheadContainerComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TypeaheadContainerComponent, "typeahead-container", never, {}, { "activeChangeEvent": "activeChange"; }, never, never, false, never>;
}
