import { window } from './facade/browser';
export var BsVerions;
(function (BsVerions) {
    BsVerions["isBs4"] = "bs4";
    BsVerions["isBs5"] = "bs5";
})(BsVerions || (BsVerions = {}));
let guessedVersion;
function _guessBsVersion() {
    const spanEl = window.document.createElement('span');
    spanEl.innerText = 'testing bs version';
    spanEl.classList.add('d-none');
    spanEl.classList.add('pl-1');
    window.document.head.appendChild(spanEl);
    const checkPadding = window.getComputedStyle(spanEl).paddingLeft;
    if (checkPadding && parseFloat(checkPadding)) {
        window.document.head.removeChild(spanEl);
        return 'bs4';
    }
    window.document.head.removeChild(spanEl);
    return 'bs5';
}
export function setTheme(theme) {
    guessedVersion = theme;
}
export function isBs4() {
    if (guessedVersion)
        return guessedVersion === 'bs4';
    guessedVersion = _guessBsVersion();
    return guessedVersion === 'bs4';
}
export function isBs5() {
    if (guessedVersion)
        return guessedVersion === 'bs5';
    guessedVersion = _guessBsVersion();
    return guessedVersion === 'bs5';
}
export function getBsVer() {
    return {
        isBs4: isBs4(),
        isBs5: isBs5()
    };
}
export function currentBsVersion() {
    const bsVer = getBsVer();
    const resVersion = Object.keys(bsVer).find(key => bsVer[key]);
    return BsVerions[resVersion];
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGhlbWUtcHJvdmlkZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvdXRpbHMvdGhlbWUtcHJvdmlkZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLE1BQU0sRUFBRSxNQUFNLGtCQUFrQixDQUFDO0FBYTFDLE1BQU0sQ0FBTixJQUFZLFNBR1g7QUFIRCxXQUFZLFNBQVM7SUFDbkIsMEJBQWEsQ0FBQTtJQUNiLDBCQUFhLENBQUE7QUFDZixDQUFDLEVBSFcsU0FBUyxLQUFULFNBQVMsUUFHcEI7QUFFRCxJQUFJLGNBQW1DLENBQUM7QUFFeEMsU0FBUyxlQUFlO0lBQ3RCLE1BQU0sTUFBTSxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3JELE1BQU0sQ0FBQyxTQUFTLEdBQUcsb0JBQW9CLENBQUM7SUFDeEMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDL0IsTUFBTSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDN0IsTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLE1BQU0sWUFBWSxHQUFHLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsQ0FBQyxXQUFXLENBQUM7SUFFakUsSUFBSSxZQUFZLElBQUksVUFBVSxDQUFDLFlBQVksQ0FBQyxFQUFFO1FBQzVDLE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUN6QyxPQUFPLEtBQUssQ0FBQztLQUNkO0lBRUQsTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLE9BQU8sS0FBSyxDQUFDO0FBQ2YsQ0FBQztBQUVELE1BQU0sVUFBVSxRQUFRLENBQUMsS0FBMEI7SUFDakQsY0FBYyxHQUFHLEtBQUssQ0FBQztBQUN6QixDQUFDO0FBRUQsTUFBTSxVQUFVLEtBQUs7SUFDbkIsSUFBSSxjQUFjO1FBQUUsT0FBTyxjQUFjLEtBQUssS0FBSyxDQUFDO0lBRXBELGNBQWMsR0FBRyxlQUFlLEVBQUUsQ0FBQztJQUNuQyxPQUFPLGNBQWMsS0FBSyxLQUFLLENBQUM7QUFDbEMsQ0FBQztBQUVELE1BQU0sVUFBVSxLQUFLO0lBQ25CLElBQUksY0FBYztRQUFFLE9BQU8sY0FBYyxLQUFLLEtBQUssQ0FBQztJQUVwRCxjQUFjLEdBQUcsZUFBZSxFQUFFLENBQUM7SUFDbkMsT0FBTyxjQUFjLEtBQUssS0FBSyxDQUFDO0FBQ2xDLENBQUM7QUFFRCxNQUFNLFVBQVUsUUFBUTtJQUN0QixPQUFPO1FBQ0wsS0FBSyxFQUFFLEtBQUssRUFBRTtRQUNkLEtBQUssRUFBRSxLQUFLLEVBQUU7S0FDZixDQUFDO0FBQ0osQ0FBQztBQUVELE1BQU0sVUFBVSxnQkFBZ0I7SUFDOUIsTUFBTSxLQUFLLEdBQUcsUUFBUSxFQUFFLENBQUM7SUFDekIsTUFBTSxVQUFVLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUM5RCxPQUFPLFNBQVMsQ0FBQyxVQUFvQyxDQUFDLENBQUM7QUFDekQsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IHdpbmRvdyB9IGZyb20gJy4vZmFjYWRlL2Jyb3dzZXInO1xuXG5leHBvcnQgdHlwZSBBdmFpbGFibGVCc1ZlcnNpb25zID0gJ2JzNCcgfCAnYnM1JztcblxuaW50ZXJmYWNlIElPYmplY3RLZXlzIHtcbiAgW2tleTogc3RyaW5nXTogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBJQnNWZXJzaW9uIGV4dGVuZHMgSU9iamVjdEtleXN7XG4gIGlzQnM0OiBib29sZWFuO1xuICBpc0JzNTogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGVudW0gQnNWZXJpb25zIHtcbiAgaXNCczQgPSAnYnM0JyxcbiAgaXNCczUgPSAnYnM1J1xufVxuXG5sZXQgZ3Vlc3NlZFZlcnNpb246IEF2YWlsYWJsZUJzVmVyc2lvbnM7XG5cbmZ1bmN0aW9uIF9ndWVzc0JzVmVyc2lvbigpOiBBdmFpbGFibGVCc1ZlcnNpb25zIHtcbiAgY29uc3Qgc3BhbkVsID0gd2luZG93LmRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ3NwYW4nKTtcbiAgc3BhbkVsLmlubmVyVGV4dCA9ICd0ZXN0aW5nIGJzIHZlcnNpb24nO1xuICBzcGFuRWwuY2xhc3NMaXN0LmFkZCgnZC1ub25lJyk7XG4gIHNwYW5FbC5jbGFzc0xpc3QuYWRkKCdwbC0xJyk7XG4gIHdpbmRvdy5kb2N1bWVudC5oZWFkLmFwcGVuZENoaWxkKHNwYW5FbCk7XG4gIGNvbnN0IGNoZWNrUGFkZGluZyA9IHdpbmRvdy5nZXRDb21wdXRlZFN0eWxlKHNwYW5FbCkucGFkZGluZ0xlZnQ7XG5cbiAgaWYgKGNoZWNrUGFkZGluZyAmJiBwYXJzZUZsb2F0KGNoZWNrUGFkZGluZykpIHtcbiAgICB3aW5kb3cuZG9jdW1lbnQuaGVhZC5yZW1vdmVDaGlsZChzcGFuRWwpO1xuICAgIHJldHVybiAnYnM0JztcbiAgfVxuXG4gIHdpbmRvdy5kb2N1bWVudC5oZWFkLnJlbW92ZUNoaWxkKHNwYW5FbCk7XG4gIHJldHVybiAnYnM1Jztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHNldFRoZW1lKHRoZW1lOiBBdmFpbGFibGVCc1ZlcnNpb25zKTogdm9pZCB7XG4gIGd1ZXNzZWRWZXJzaW9uID0gdGhlbWU7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc0JzNCgpOiBib29sZWFuIHtcbiAgaWYgKGd1ZXNzZWRWZXJzaW9uKSByZXR1cm4gZ3Vlc3NlZFZlcnNpb24gPT09ICdiczQnO1xuXG4gIGd1ZXNzZWRWZXJzaW9uID0gX2d1ZXNzQnNWZXJzaW9uKCk7XG4gIHJldHVybiBndWVzc2VkVmVyc2lvbiA9PT0gJ2JzNCc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc0JzNSgpOiBib29sZWFuIHtcbiAgaWYgKGd1ZXNzZWRWZXJzaW9uKSByZXR1cm4gZ3Vlc3NlZFZlcnNpb24gPT09ICdiczUnO1xuXG4gIGd1ZXNzZWRWZXJzaW9uID0gX2d1ZXNzQnNWZXJzaW9uKCk7XG4gIHJldHVybiBndWVzc2VkVmVyc2lvbiA9PT0gJ2JzNSc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRCc1ZlcigpOiBJQnNWZXJzaW9uIHtcbiAgcmV0dXJuIHtcbiAgICBpc0JzNDogaXNCczQoKSxcbiAgICBpc0JzNTogaXNCczUoKVxuICB9O1xufVxuXG5leHBvcnQgZnVuY3Rpb24gY3VycmVudEJzVmVyc2lvbigpOiBBdmFpbGFibGVCc1ZlcnNpb25zIHtcbiAgY29uc3QgYnNWZXIgPSBnZXRCc1ZlcigpO1xuICBjb25zdCByZXNWZXJzaW9uID0gT2JqZWN0LmtleXMoYnNWZXIpLmZpbmQoa2V5ID0+IGJzVmVyW2tleV0pO1xuICByZXR1cm4gQnNWZXJpb25zW3Jlc1ZlcnNpb24gYXMga2V5b2YgdHlwZW9mIEJzVmVyaW9uc107XG59XG5cblxuIl19