import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { EsignComponent } from './esign/esign.component';



import { FormComponent } from './form/form.component';
import { UserListComponent } from './user-list/user-list.component';
import { ThankYouComponent } from './thank-you/thank-you.component';

const routes: Routes = [
  { path: 'user-list', component: UserListComponent },
  { path: 'form/:id', component: FormComponent },
  { path: 'esign/:id', component: EsignComponent },
  { path: 'thank-you', component: ThankYouComponent },
  { path: '', redirectTo: 'user-list', pathMatch: 'full' },
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule { }
