import { AfterViewInit, Component, OnInit, ViewChild } from '@angular/core';
import { NgSignaturePadOptions, SignaturePadComponent } from '@almothafar/angular-signature-pad';
import { GetClientsService } from 'src/services/get-clients.service';
import { ActivatedRoute, Router } from '@angular/router';
import { GoogleMap, MapInfoWindow, MapMarker } from '@angular/google-maps';
import { form } from '../form';
import { HttpClient } from '@angular/common/http';
import { LocationService } from 'src/services/location.service';
import { FormBuilder, FormGroup, FormControl, Validators } from '@angular/forms';
@Component({
  selector: 'app-esign',
  templateUrl: './esign.component.html',
  styleUrls: ['./esign.component.css']
})
export class EsignComponent implements OnInit{
  @ViewChild('signature')
  public signaturePad: SignaturePadComponent;
  public signaturePadOptions: NgSignaturePadOptions = { // passed through to szimek/signature_pad constructor
    minWidth: 5,
    canvasWidth: 600,
    canvasHeight: 300
  };
geolocation: any;
locationjs: any;
  caca: string;
  bite: form;
  lat: any;
  dat: any;
  lon: any;
  submited = false;
  signForm: FormGroup;
  geolocationtemp: string;

  constructor(
    private getclients : GetClientsService,
    private router : ActivatedRoute,
    private http: HttpClient,
    private location: LocationService,
    private fb: FormBuilder
  ) {
    // no-op
  }
  loading = false;
  @ViewChild(GoogleMap, { static: false }) map: GoogleMap;
  @ViewChild(MapInfoWindow, { static: false }) infoWindow: MapInfoWindow;
  mapZoom = 12;
  mapCenter: google.maps.LatLng;
  mapOptions: google.maps.MapOptions = {
    mapTypeId: google.maps.MapTypeId.ROADMAP,
    zoomControl: true,
    scrollwheel: false,
    disableDoubleClickZoom: true,
    maxZoom: 20,
    minZoom: 4,
  };
 
  markerInfoContent = '';
  markerOptions: google.maps.MarkerOptions = {
    draggable: false,
    animation: google.maps.Animation.DROP,
  };

  initializeForm(): void {
    this.signForm = this.fb.group({
      'avis': new FormControl(null),
      'commentaire': new FormControl(null),
      'select': new FormControl(null, Validators.required),

    });
  }

ngOnInit(): void {
  this.getclients.getInfo(this.router.snapshot.paramMap.get('id')).subscribe({
    next: data => {
      console.log(data);
      this.bite = new form(data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7]);
      document.getElementById("caca").innerHTML = data[6] + "<style>td,th {    border: 1px solid rgb(190, 190, 190);      padding: 10px;}td {   text-align: center; } tr:nth-child(even) {background-color: #eee;}th[scope='col'] {background-color: #696969;color: #fff;} th[scope='row'] {background-color: #d7d9f2;}caption {padding: 10px;caption-side: bottom;}table { margin-left: auto; margin-right: auto; border-collapse: collapse;border: 2px solid rgb(200, 200, 200);letter-spacing: 1px;font-family: sans-serif;font-size: 0.8rem;}</style> "
    }
    
  })
  this.initializeForm();
  this.location.getLocation().subscribe((response)=>{
    console.table(response);
    this.geolocation = response;
    console.log(this.geolocation.city);
  })

  // navigator.geolocation.getCurrentPosition((position)=>{
  //   console.log(position);
  //   this.locationjs = position.coords;
  // })
}
// options: google.maps.MapOptions = {
//   center: {lat: 24, lng: 25},
//   zoom: 4,

// };
  ngAfterViewInit() {
    // this.signaturePad is now available
    this.signaturePad.set('minWidth', 5); // set szimek/signature_pad options at runtime
    this.signaturePad.clear(); // invoke functions from szimek/signature_pad API
    this.locationjs.latitude  = this.lat;
    this.locationjs.longitude = this.lon;

    console.log(this.geolocationtemp);


  }


  drawComplete(event: MouseEvent | Touch) {
    // will be notified of szimek/signature_pad's onEnd event
    console.log('Completed drawing', event);
    console.log(this.signaturePad.toDataURL());
  }
  onClear(){
this.signaturePad.clear();
  }
  drawStart(event: MouseEvent | Touch) {
    // will be notified of szimek/signature_pad's onBegin event
    console.log('Start drawing', event);
  }

  
  onSubmit(){
    this.getclients.sendSignature(this.router.snapshot.paramMap.get('id'), this.signaturePad.toDataURL(),this.geolocation.city,this.signForm.value['avis'],this.signForm.value['commentaire'],this.signForm.value['select']).subscribe({
      next: data => {
        console.log(data);
      }
    });
    // console.log(this.signForm.value); 
    // console.log(this.geolocation.city);
    this.submited = true;
    setTimeout(function(){
      window.location.replace("/thank-you");
  }
  , 1500);
  }
  openInfoWindow(marker: MapMarker) { 
    // this is called when the marker is clicked.
    this.infoWindow.open(marker);
  }

  // getCurrentLocation() {
  //   this.loading = true;
  
  //   navigator.geolocation.getCurrentPosition(
  //     (position: GeolocationPosition) => {
  //       this.loading = false;
  
  //       const point: google.maps.LatLngLiteral = {
  //         lat: position.coords.latitude,
  //         lng: position.coords.longitude,
  //       };
  
  //       this.mapCenter = new google.maps.LatLng(point);
  //       this.map.panTo(point);
  
  //       this.markerInfoContent = "I'm here!";
  
  //       this.markerOptions = {
  //         draggable: false,
  //         animation: google.maps.Animation.DROP,
  //       };
  //     },
  //     (error) => {
  //       this.loading = false;
  
  //       if (error.PERMISSION_DENIED) {
  //         console.log("Couldn't get your location", 'Permission denied');
  //       } else if (error.POSITION_UNAVAILABLE) {
  //         console.log(
  //           "Couldn't get your location",
  //           'Position unavailable'
  //         );
  //       } else if (error.TIMEOUT) {
  //         console.log("Couldn't get your location", 'Timed out');
  //       } else {
  //         console.log(error.message, `Error: ${error.code}`);
  //       }
  //     },
  //     { enableHighAccuracy: true }
  //   );
  // }


}