import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { GenerateIdService } from 'src/services/generate-id.service';
import { users } from '../users';
import { FormArray, FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { GetClientsService } from 'src/services/get-clients.service';
import { material } from './material';
@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})

export class FormComponent implements OnInit{
submited = false;
material = new material()
data = [];
interventionForm : FormGroup;  

constructor(
  private genid: GenerateIdService,
  private fb: FormBuilder,
  private getClients :GetClientsService,
  private router: ActivatedRoute
  ){}

ngOnInit(): void {
  this.initializeForm();
 const caca = this.genid.generate()  
 console.log(caca);
 this.data.push(this.material);
}


initializeForm(): void {
  this.interventionForm = this.fb.group({
    'title': new FormControl(null, Validators.required),
    'description': new FormControl(null, Validators.required),
  });
}


addForm() {
this.material = new material()
this.data.push(this.material);
}
removeForm(index: number){
this.data.splice(index, 1);
}

onSubmit(){
  // console.log(this.interventionForm.value);
  // console.log(this.types[0]);
  this.getClients.sendForm(this.interventionForm.value['title'], this.interventionForm.value['description'], this.data ,this.router.snapshot.paramMap.get('id')).subscribe({
    next: data => {
      
      console.log(data);
    }
  });
  this.submited = true;


  setTimeout(location.reload.bind(location), 1500);
//   setTimeout(function(){
//     window.location.replace("/user-list");
// }
// , 1500);
}
// removevalue(i){
//   this.types.splice(i,1);

// }

// addType(){
//   this.types.push({value: ""});




// }
// addValue(){
//   this.types.push(this.fb.control(''))
// }


// addRemarque(){
//   this.remarques.push({value: ""});
// }
}

