import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders, HttpErrorResponse, HttpParams } from '@angular/common/http';
import { Observable } from 'rxjs';
import { ArrayType } from '@angular/compiler';




const httpOptions = {
  headers: new HttpHeaders({ 
    'Content-Type': 'application/json',
  })
};




@Injectable({
  providedIn: 'root'
})
export class GetClientsService {

  constructor(private http: HttpClient) { }



  getClients(): Observable<any> {
    return this.http.get(
      'https://crm.jfm-audit.com/index.php?entryPoint=1ststep',

    );
  }




 sendForm(title: string, description: string, material: Array<Array<string>> ,idclient: string): Observable <any> {
  return this.http.post(
    'https://crm.jfm-audit.com/index.php?entryPoint=2ndstep',
    { 
      title: title,
      description: description,
      material: material,
      idclient: idclient
    },
  );
 }  


  getInfo(id: string): Observable <any> {
    return this.http.post(
      'https://crm.jfm-audit.com/index.php?entryPoint=3rdstep',
      {
        id: id,
      },
      httpOptions
    );
  }



 sendSignature(id: string, img:string, city:string, avis: string, commentaire: string, select: string,): Observable <any> {
  return this.http.post(
    'https://crm.jfm-audit.com/index.php?entryPoint=4thstep',
    {
      id: id,
      img: img,
      city: city,
      avis: avis,
      commentaire: commentaire,
      select: select,
    
      
    },
    httpOptions
  );
 }
}


