#!/bin/bash

# 0. Save all folder names from wp-content/plugins/ to a variable
if [ -d wp-content/plugins ]; then
    echo "Saving plugin folder names..."
    PLUGIN_FOLDERS=$(ls -d wp-content/plugins/*/)
else
    echo "No plugins directory found."
    PLUGIN_FOLDERS=""
fi

# 1. Download and unzip WordPress
echo "Downloading WordPress..."
wget https://fr.wordpress.org/latest-fr_FR.zip -O wordpress.zip
echo "Unzipping WordPress..."
unzip wordpress.zip -d ./wordpress

# 2. Copy the wp-config.php to backconfig
if [ -f wp-config.php ]; then
    echo "Backing up wp-config.php..."
    cp wp-config.php backconfig
else
    echo "wp-config.php not found. Skipping backup."
fi

# 3. Erase all .php files in the current folder
echo "Deleting all .php files in the current folder..."
find . -maxdepth 1 -type f -name "*.php" -exec rm -f {} \;

# 4. Erase wp-admin and wp-includes folders
echo "Deleting wp-admin and wp-includes folders..."
rm -rf wp-admin wp-includes

# 5. Copy wp-admin and wp-includes from the downloaded WordPress folder to the current directory
echo "Copying wp-admin and wp-includes from the downloaded WordPress..."
cp -r wordpress/wordpress/wp-admin .
cp -r wordpress/wordpress/wp-includes .

# 6. Erase the folders themes, plugins, languages, and upgrade from wp-content and recreate them
echo "Resetting themes, plugins, languages, and upgrade folders in wp-content..."
rm -rf wp-content/themes wp-content/plugins wp-content/languages wp-content/upgrade
mkdir -p wp-content/themes wp-content/plugins wp-content/languages wp-content/upgrade

# 7. Erase all .php files inside wp-content
echo "Deleting all .php files in wp-content..."
find wp-content -maxdepth 1 -type f -name "*.php" -exec rm -f {} \;

# 8. Copy all php from wordpress
cp wordpress/wordpress/*.php .
cp backconfig wp-config.php

# 9. echo plugins
if [ -n "$PLUGIN_FOLDERS" ]; then
    echo "You should re-download all these plugins: "
    echo "$PLUGIN_FOLDERS"
else
    echo "No plugins found to re-download."
fi

# 10. Erase wordpress 
rm -rf wordpress
rm wordpress.zip

# 11. Change rights 

chown -R dev1:www-data .
chmod -R 554 .
chmod -R 754 wp-content